/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
* File name     : propdefs.h
************************************************************************
* Written by    : Christian Zurhorst, BID R&D, 24.11.97
* Last modified : ask clearcase
************************************************************************
* File contents :
*                 own type definitions, taken out of mini_api.h 
************************************************************************
* NOTES :
************************************************************************
*/

/*----------------------------------------------------------------------
 * Performance Board property types definitions added:
 * Robert Siegmund, 10.03.07, BID R&D
 *----------------------------------------------------------------------*/


#ifndef PROPDEFS_H_INCLUDED                               
#define PROPDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif



/* --------------------------------------------------------------------------
 * Onboard Resource definitions
 * -------------------------------------------------------------------------- */

#define B_RESOURCE_SIZE 29

  /* TODO: check lockable resources */
CLI typedef enum {
  B_RESLOCK_MAILBOX,		/* @mailbox */
  B_RESLOCK_CPUPORT,		/* @cpuport */
  B_RESLOCK_STATIC_IO,  		/* @statio */
  B_RESLOCK_EXERCISER,		/* @exe */
  B_RESLOCK_TRACEMEM,             	/* @trc */
  B_RESLOCK_OBSERVER,		/* @obs */
  B_RESLOCK_PERFORMANCE,		/* @perfor */
  B_RESLOCK_SST,			/* @sst */
  B_RESLOCK_PATT_TERM_0,		/* @pt0 */
  B_RESLOCK_PATT_TERM_1,		/* @pt1 */
  B_RESLOCK_PATT_TERM_2,		/* @pt2 */
  B_RESLOCK_PATT_TERM_3,		/* @pt3 */
  B_RESLOCK_PATT_TERM_4,		/* @pt4 */
  B_RESLOCK_PATT_TERM_5,		/* @pt5 */
  B_RESLOCK_PATT_TERM_6,		/* @pt6 */
  B_RESLOCK_PATT_TERM_7,		/* @pt7 */
  B_RESLOCK_PATT_TERM_8,		/* @pt8 */
  B_RESLOCK_PATT_TERM_9,		/* @pt9 */
  B_RESLOCK_PATT_TERM_10,		/* @pt10 */
  B_RESLOCK_PATT_TERM_11,		/* @pt11 */
  B_RESLOCK_PATT_TERM_12,		/* @pt12 */
  B_RESLOCK_PATT_TERM_13,		/* @pt13 */
  B_RESLOCK_PATT_TERM_14,		/* @pt14 */
  B_RESLOCK_PATT_TERM_15,		/* @pt15 */
  B_RESLOCK_PATT_TERM_16,		/* @pt16 */
  B_RESLOCK_PATT_TERM_17,		/* @pt17 */
  B_RESLOCK_PATT_TERM_18,		/* @pt18 */
  B_RESLOCK_PATT_TERM_19,		/* @pt19 */
  B_RESLOCK_PATT_TERM_20		/* @pt20 */
} b_resourcetype;

/* Note; B_RESLOCK_MEM_xxx enums are used primarily by the firmware */


/* ---------------------------------------------------------------
 * Onboard version information ...
 * NOTE:
 * Do only append to this structure, never insert. Numbers have to
 * be kept over different software versions to maintain updatability.
 * CZ
 * --------------------------------------------------------------- */
CLI typedef enum {
  B_VER_PRODUCT,   /* @product */
  B_VER_SERIAL,    /* @serial */
  B_VER_BOARD,     /* @board */
  B_VER_SMDATE,    /* @smdate */
  B_VER_DPDATE,    /* @dpdate */
  B_VER_LATTDATE,  /* @lattdate */
  B_VER_XILDATE,   /* @xildate */
  B_VER_FIRMWARE,  /* @firmware */
  B_VER_CORE,      /* @core */
  B_VER_DEEPTRACE, /* @deep */
  B_VER_CAPI,      /* @capi */
  B_VER_ICHIBAN,   /* @ichiban */
  B_VER_TEAM,       /* @team */
  B_VER_FIRMWARE_DATE  /* @firmwaredate */
} b_versionproptype; 

/* datecodes from the firmware / core */
CLI typedef enum {
  B_DATECODE_XILINX,		/* @datexilinx */
  B_DATECODE_DTALTERA		/* @datedtaltera */
} b_datecodeproptype;

/* ---------------------------------------------------------------
 * 23.1.98; b_cpuproptype (CPU Port Programming) -> cpupdefs.h
 * --------------------------------------------------------------- */

/* ---------------------------------------------------------------
 * Type Definitions for Power Up Behavior Programming Functions
 * --------------------------------------------------------------- */

#define B_PUPROP_SIZE		 6

CLI typedef enum {
  B_PU_OBSRUNMODE,      /* @obsrunmode  */
  B_PU_TRCRUNMODE,      /* @trcrunmode  */
  B_PU_SSTRUNMODE,      /* @sstrunmode  */
  B_PU_CONFRESTORE,     /* @confrestore */
  B_PU_MASTERRUNMODE,   /* @mrunmode    */
  B_PU_TCRUNMODE  	/* @tcrunmode   */
} b_puproptype;

/*----------------------------------------------------------------------
 * Defines for confrestore powerup property
 *----------------------------------------------------------------------*/

CLI				/* DEF_START ~G_PUConfRestore */
#define B_CFRST_BIOSPU 0		/* @biospu */
#define B_CFRST_NOBIOS 1		/* @nobios */
#define B_CFRST_BIOS   2		/* @bios */
CLI				/* DEF_END */

CLI				/* DEF_START ~G_PUMasterRun */
#define B_MRUN_OFF    16		/* @mrunoff */
CLI				/* DEF_END */


/* ---------------------------------------------------------------
 * Type Definitions for Miscelleaneous Functions                 
 * --------------------------------------------------------------- */

CLI                             /* DEF_START ~G_G21 */
#define B_RSTMODE_RESETSM      0x1  /* @resetsm */
#define B_RSTMODE_RESETALL     0x0  /* @resetall */
#define B_RSTMODE_RESETCONFIG  0x2  /* @resetconfig */
CLI                             /* DEF_END */


#define B_CAPIPROP_SIZE		2
CLI typedef enum {
  B_CAPI_BLOCKMAX,	/* @blkmax */
  B_CAPI_QUICKUPDATE    /* @quickupdate */
} b_capiproptype;


typedef enum {
  B_MBLOCK_MEM_0,
  B_MBLOCK_MEM_1,
  B_MBLOCK_MEM_2,
  B_MBLOCK_MEM_3,
  B_MBLOCK_MEM_4,
  B_MBLOCK_MEM_5,
  B_MBLOCK_MEM_6,
  B_MBLOCK_MEM_7,
  B_MBLOCK_MEM_8,
  B_MBLOCK_MEM_9,
  B_MATTR_MEM_0,
  B_MATTR_MEM_1,
  B_MATTR_MEM_2,
  B_MATTR_MEM_3,
  B_MATTR_MEM_4,
  B_MATTR_MEM_5,
  B_MATTR_MEM_6,
  B_MATTR_MEM_7,
  B_MATTR_MEM_8,
  B_MATTR_MEM_9,
  B_MATTR_MEM_10,
  B_MATTR_MEM_11,
  B_MATTR_MEM_12,
  B_MATTR_MEM_13,
  B_MATTR_MEM_14,
  B_MBYTEN_MEM_0,
  B_TATTR_MEM_0,
  B_TATTR_MEM_1,
  B_TATTR_MEM_2,
  B_TATTR_MEM_3,
  B_TATTR_MEM_4,
  B_TATTR_MEM_5,
  B_TATTR_MEM_6,
  B_TATTR_MEM_7,
  B_TATTR_MEM_8,
  B_AMAP_MEM_0,
  B_AMAP_MEM_1,
  B_AMAP_MEM_2,
  B_CONTEXT_MEM,
  B_ISSEQ_MEM,
  B_MSEQ_MEM,
  B_TSEQ_MEM,
  B_PERFSEQ_MEM_0,
  B_PERFSEQ_MEM_1,
  B_PERFSEQ_MEM_2,
  B_PERFSEQ_MEM_3,
  B_PERFSEQ_MEM_4,
  B_PERFSEQ_MEM_5,
  B_PERFSEQ_MEM_6,
  B_PERFSEQ_MEM_7,
  B_CSTRULE_MEM_0,
  B_CSTRULE_MEM_1,
  B_CSTRULE_MEM_2,
  B_CSTRULE_MEM_3,
  B_CSTRULE_MEM_4,
  B_CSTRULE_MEM_5,
  B_CSTRULE_MEM_6,
  B_CSTRULE_MEM_7,
  B_TRIGIOSEQ_MEM,
  B_TRIGSEQ_MEM,
  B_SELFTEST_COUNT	/* internal use only */
} b_selftesttype;


/* ---------------------------------------------------------------
 * Defines for Trace & External Trigger Functions
 * --------------------------------------------------------------- */
CLI /* DEF_START ~G_G14 */
#define B_HBMODE_ON            0x1  /* @on  */
#define B_HBMODE_OFF           0x0  /* @off */
#define B_E2925_COMPATIBLE     0x0  /* @e2925  */
#define B_PERFORMANCE          0x1  /* @perf */
#define B_PATT0MODE_STANDARD   0x0  /* @standard */
#define B_PATT0MODE_DIFFERENTIAL 0x1 /* @differential */
#define B_TRIG15IO_INPUT        0x0  /* @in  */
#define B_TRIG15IO_OUTPUT       0x1  /* @out */
CLI /* DEF_END */



/* ---------------------------------------------------------------
 * Type Definitions for Host to PCI Access Functions
 * --------------------------------------------------------------- */
CLI typedef enum {
  B_ASP_CONFIG,       /* @config      */
  B_ASP_CONFIG_TYPE1, /* @configtype1 */
  B_ASP_IO,           /* @io          */
  B_ASP_MEM           /* @mem         */
} b_addrspacetype;


/* ---------------------------------------------------------------
 * Type Definitions for Test Functions
 * --------------------------------------------------------------- */
CLI typedef enum {
  B_TST_BANDWIDTH,	/* @bw */
  B_TST_BLKLENGTH,	/* @blklen */
  B_TST_DATAPATTERN,	/* @dpat */
  B_TST_PROTOCOL,	/* @prot */
  B_TST_COMPARE,	/* @comp */
  B_TST_STARTADDR,	/* @start */
  B_TST_NOFBYTES,	/* @nob */
  B_TST_SOURCEADDR,	/* @source */
  B_TST_DESTINADDR,	/* @dest */
  B_TST_TIMEDIST,	/* @timedist */
  B_TST_TIMELIMIT	/* @timelimit */
} b_testproptype;

CLI typedef enum {
  B_TIM_ACTUALVAL,	/* @actual */
  B_TIM_TESTERROR,	/* @testerror */
  B_TIM_PROTERROR,	/* @proterror */
  B_TIM_TRACETRIG	/* @trig */
} b_timertype;


/* ---------------------------------------------------------------
 * Debug Switches for onboard debugging
 * --------------------------------------------------------------- */
CLI typedef enum {
  B_FW_BOOT,                    /* @boot */
  B_FW_ANALYZER,                /* @ana */
  B_FW_EXERCISER,               /* @exe */
  B_FW_PARSE,                   /* @parse */
  B_FW_HAL,                     /* @hal */
  B_FW_EDITSET,                 /* @edit */
  B_FW_HOSTINT,                 /* @host */
  B_FW_PPR,                     /* @ppr */
  B_FW_SST,                     /* @sst */
  B_FW_RS232,                   /* @rs232 */
  B_FW_PARALLEL,                /* @para */
  B_FW_PCI,                     /* @pci */
  B_FW_DECODE,                  /* @dec */
  B_FW_SERVICES,                /* @service */
  B_FW_PERF,                    /* @perf */
  B_FW_TRACEINOUT,              /* @trace */
  B_FW_STACK,			/* @stack */
  B_FW_SYSTEM,                  /* @system */
  B_FW_APPLICATION,             /* @appl */
  B_FW_PSOS,			/* @psos */
  B_FW_PPISTATE,                /* @ppi */
  B_FW_PPIOTHER,                /* @ppiother */
  B_FW_PORTS,                   /* @ports */
  B_FW_ALL = 255                /* @all */
} b_debugtype;

/* ---------------------------------------------------------------
 * Defines for Hex Display Functions
 * --------------------------------------------------------------- */
CLI /* DEF_START ~G_G20 */
#define B_DISP_USER            0x1  /* @user */
#define B_DISP_CARD            0x0  /* @card */
CLI /* DEF_END */


/* ---------------------------------------------------------------
 * Defines for Test Functions
 * --------------------------------------------------------------- */
CLI /* DEF_START ~G_G22 */
#define B_DATAPATTERN_RANDOM   0x0  /* @dprandom */
#define B_DATAPATTERN_FIX      0x1  /* @dpfix */
#define B_DATAPATTERN_TOGGLE   0x2  /* @dptoggle */
CLI /* DEF_END */

CLI /* DEF_START ~G_G23 */
#define B_PROTOCOL_LITE        0x0  /* @lite */
#define B_PROTOCOL_MEDIUM      0x1  /* @medium */
#define B_PROTOCOL_HARD        0x2  /* @hard */
CLI /* DEF_END */


/******************************************************************************/
/* The test command is a mask which defines how many and what type of entries 
 * will be added to a Master Block Page for EACH attribute page used for
 * each type of test.  
 *
 * Each type of test is made up of one or more of the following;
 * 1. Read to upper half of internal memory.
 * 2. Write from upper half of internal memory.
 * 3. Read to lower half of internal memory (necessary for compare).
 *
 */
#define PBP_READ_TO_UPPER_HALF      0x1
#define PBP_WRITE_FROM_UPPER_HALF   0x2
#define PBP_READ_TO_LOWER_HALF      0x4
#define PBP_COMPARE                 0x8

/* ALL B_TSTCMD_ defines MUST be made up from the PBP_ defines above */

CLI /* DEF_START ~G_G24 */
#define B_TSTCMD_INTGENERATE   0x0  /* @intgenerate */
#define B_TSTCMD_TRAFFICMAKE   0x2  /* @trafficmake */
#define B_TSTCMD_BLOCKMOVE     0x3  /* @blockmove */
#define B_TSTCMD_READ	         0x4  /* @read */
#define B_TSTCMD_WRITEREAD     0x6  /* @writeread */
CLI /* DEF_END */


/* This table describes the bus addresses used for different test modes 
 * 
 *                          Read Src.           Write Dest.
 * B_TSTCMD_TRAFFICMAKE       -                 Target
 * B_TSTCMD_BLOCKMOVE       B_TST_SOURCEADDR    B_TST_DESTINADDR
 * B_TSTCMD_READ            B_TST_SOURCEADDR    B_TST_SOURCEADDR
 * B_TSTCMD_WRITEREAD       B_TST_SOURCEADDR    B_TST_SOURCEADDR
 */

/* Exerciser properties */
#define B_EGENPROP_SIZE	 1

CLI typedef enum {
  B_EGEN_ATTRPAGESIZE     /* @attrpagesize */
} b_exercisergenproptype;

/* Timing Checker power-up values */

CLI                           /* DEF_START ~G_PUTimCheck */
#define B_TC_OFF 0	      /* @tcoff */
#define B_TC_FREQ_CURR 1      /* @tcfcurr */
#define B_TC_FREQ_MEAS 2      /* @tcfmeas */
CLI                           /* DEF_END */



#endif






